local onColor = color("1,0,0,0.75")
local offColor = color("1,0,0,0.125")
local effectTime = 1

return Def.ActorFrame{
	Def.ActorFrame{
		Name="CenterDangerDisplay";
		InitCommand=cmd(Center);
		DangerOnMessageCommand=function(self)
			self:GetChild("Top"):playcommand("DangerOn")
			self:GetChild("Middle"):playcommand("DangerOn")
			self:GetChild("Bottom"):playcommand("DangerOn")
		end;
		DangerOffMessageCommand=function(self)
			self:GetChild("Top"):playcommand("DangerOff")
			self:GetChild("Middle"):playcommand("DangerOff")
			self:GetChild("Bottom"):playcommand("DangerOff")
		end;
		OffCommand=function(self)
			self:GetChild("Top"):playcommand("DangerOff")
			self:GetChild("Middle"):playcommand("DangerOff")
			self:GetChild("Bottom"):playcommand("DangerOff")
		end;

		Def.Quad{
			Name="Top";
			InitCommand=cmd(y,-40;zoomto,SCREEN_WIDTH,32;fadetop,1;diffuse,color("1,0,0,0"));
			DangerOnCommand=cmd(linear,0.2;diffusealpha,1;diffuseshift;effectcolor1,onColor;effectcolor2,offColor;effectperiod,effectTime);
			DangerOffCommand=cmd(stopeffect;stoptweening;linear,0.125;diffusealpha,0);
		};

		Def.Quad{
			Name="Middle";
			InitCommand=cmd(zoomto,SCREEN_WIDTH,48;diffuse,color("1,0,0,0"));
			DangerOnCommand=cmd(linear,0.2;diffusealpha,1;diffuseshift;effectcolor1,onColor;effectcolor2,offColor;effectperiod,effectTime);
			DangerOffCommand=cmd(stopeffect;stoptweening;linear,0.125;diffusealpha,0);
		};

		Def.Quad{
			Name="Bottom";
			InitCommand=cmd(y,40;zoomto,SCREEN_WIDTH,32;fadebottom,1;diffuse,color("1,0,0,0"));
			DangerOnCommand=cmd(linear,0.2;diffusealpha,1;diffuseshift;effectcolor1,onColor;effectcolor2,offColor;effectperiod,effectTime);
			DangerOffCommand=cmd(stopeffect;stoptweening;linear,0.125;diffusealpha,0);
		};
	};
};